"""Abstract base class for defining control profiles."""
from abc import ABC, abstractmethod
from typing import Optional

from gymnasium.core import ActType
from xr import Posef

from bigym.bigym_env import BiGymEnv
from vr.viewer.xr_context import XRContextObject


class ControlProfile(ABC):
    """Abstract base class for defining control profiles."""

    def __init__(self):
        """Init."""
        # Will be initialized later
        self._env: Optional[BiGymEnv] = None

    def bind_environment(self, env: BiGymEnv):
        """Assign instance of controlled environment."""
        self._env = env

    @abstractmethod
    def get_next_action(
        self,
        context: XRContextObject,
        steps_predicted: int,
        space_offset: Posef,
    ) -> ActType:
        """Get the next action.

        :param context: XR context object to access current input.
        :param steps_predicted: Predicted amount of physical steps to be taken
            to keep Mujoco environment in sync with VR rendering loop.
        :param space_offset: Virtual space offset.
        """
        pass
